package gov.va.med.mhv.usermgmt.web.converter;

import java.io.Serializable;

import gov.va.med.mhv.common.api.dto.EmergencyContactDTO;
import gov.va.med.mhv.usermgmt.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.usermgmt.web.formbean.CareGiver;
import gov.va.med.mhv.usermgmt.web.formbean.EmergencyContact;

public class CareGiverConverter implements Serializable  {

	private static final long serialVersionUID = 4354768754414577477L;

	public CareGiver convert(HealthCareProviderDTO d) {
		CareGiver cg = new CareGiver();
		cg.setCareGiverId(d.getHealthCareProviderId());
		cg.setComments(d.getComments());
		cg.setEmailAddress(d.getEmailAddress());
		cg.setFirstName(d.getFirstName());
		cg.setLastName(d.getLastName());
		cg.setOtherClinician(d.getOtherClinician());
		cg.setWorkPhone(d.getWorkPhone());
		cg.setWorkPhoneExt(d.getWorkPhoneExt());
		cg.setProviderType(d.getProviderType());
		cg.setUserProfileId(d.getUserProfileId());
		return cg;
	}

	public HealthCareProviderDTO convertToDto(CareGiver cg) {
		HealthCareProviderDTO dto = new HealthCareProviderDTO();
		dto.setComments(cg.getComments());
		dto.setEmailAddress(cg.getEmailAddress());
		dto.setFirstName(cg.getFirstName());
		dto.setHealthCareProviderId(cg.getCareGiverId());
		dto.setLastName(cg.getLastName());
		dto.setOtherClinician(cg.getOtherClinician());
		dto.setProviderType(cg.getProviderType());
		dto.setUserProfileId(cg.getUserProfileId());
		dto.setWorkPhone(cg.getWorkPhone());
		dto.setWorkPhoneExt(cg.getWorkPhoneExt());
		return dto;
	}
	
}
